<?php 

return (object) [
    'entries_to_show'               => 8, // Entries to show on the homepage.
    'show_entry_list_excerpt'       => true, // If available, description will be shown.
    'excerpt_length'                => 20, // In words.
    'show_site_name_logo'           => false, // Show website name next to logo
    'show_site_slogan'              => false,
    'show_categories_in_menu'       => true, // Show categories in the menu
    'show_all_static_pages_in_menu' => true, // Show all pages or just if the page has show_in_menu custom metadata
    'show_sharing_links'            => true,

    'menu_icon'                     => '<svg width="22" height="12" viewBox="0 0 22 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21 8.5V3.5L17.25 6L13.5 3.5V8.5M1 1H21H1ZM1 6H11H1ZM1 11H21H1Z" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    'tag_icon'                      => '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1 21V14.3333L14.3333 1L21 7.66667L7.66667 21H1Z" stroke="#0A0A0A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',

    'show_social_links'             => true,
    'youtube_icon'                  => 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/PjwhRE9DVFlQRSBzdmcgIFBVQkxJQyAnLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4nICAnaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkJz48c3ZnIGhlaWdodD0iMTAwJSIgc3R5bGU9ImZpbGwtcnVsZTpldmVub2RkO2NsaXAtcnVsZTpldmVub2RkO3N0cm9rZS1saW5lam9pbjpyb3VuZDtzdHJva2UtbWl0ZXJsaW1pdDoyOyIgdmVyc2lvbj0iMS4xIiB2aWV3Qm94PSIwIDAgNTEyIDUxMiIgd2lkdGg9IjEwMCUiIHhtbDpzcGFjZT0icHJlc2VydmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6c2VyaWY9Imh0dHA6Ly93d3cuc2VyaWYuY29tLyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPjxwYXRoIGQ9Ik0yNTYsMGMxNDEuMjksMCAyNTYsMTE0LjcxIDI1NiwyNTZjMCwxNDEuMjkgLTExNC43MSwyNTYgLTI1NiwyNTZjLTE0MS4yOSwwIC0yNTYsLTExNC43MSAtMjU2LC0yNTZjMCwtMTQxLjI5IDExNC43MSwtMjU2IDI1NiwtMjU2Wm0xNTMuMzE1LDE3OC45NzhjLTMuNjgsLTEzLjc2OSAtMTQuNTIyLC0yNC42MSAtMjguMjksLTI4LjI5Yy0yNC45NTgsLTYuNjg4IC0xMjUuMDI1LC02LjY4OCAtMTI1LjAyNSwtNi42ODhjMCwwIC0xMDAuMDY3LDAgLTEyNS4wMjUsNi42ODhjLTEzLjc2NSwzLjY4IC0yNC42MSwxNC41MjEgLTI4LjI5LDI4LjI5Yy02LjY4NSwyNC45NTUgLTYuNjg1LDc3LjAyNCAtNi42ODUsNzcuMDI0YzAsMCAwLDUyLjA2NyA2LjY4NSw3Ny4wMmMzLjY4LDEzLjc2OSAxNC41MjUsMjQuNjE0IDI4LjI5LDI4LjI5M2MyNC45NTgsNi42ODUgMTI1LjAyNSw2LjY4NSAxMjUuMDI1LDYuNjg1YzAsMCAxMDAuMDY3LDAgMTI1LjAyNSwtNi42ODVjMTMuNzY4LC0zLjY3OSAyNC42MSwtMTQuNTI0IDI4LjI5LC0yOC4yOTNjNi42ODUsLTI0Ljk1MyA2LjY4NSwtNzcuMDIgNi42ODUsLTc3LjAyYzAsMCAwLC01Mi4wNjkgLTYuNjg1LC03Ny4wMjRabS0xODUuMzE2LDEyNS4wMjVsMCwtOTYuMDAybDgzLjEzNyw0OC4wMDFsLTgzLjEzNyw0OC4wMDFaIi8+PC9zdmc+',
    'facebook_icon'                 => 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/PjwhRE9DVFlQRSBzdmcgIFBVQkxJQyAnLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4nICAnaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkJz48c3ZnIGhlaWdodD0iMTAwJSIgc3R5bGU9ImZpbGwtcnVsZTpldmVub2RkO2NsaXAtcnVsZTpldmVub2RkO3N0cm9rZS1saW5lam9pbjpyb3VuZDtzdHJva2UtbWl0ZXJsaW1pdDoyOyIgdmVyc2lvbj0iMS4xIiB2aWV3Qm94PSIwIDAgNTEyIDUxMiIgd2lkdGg9IjEwMCUiIHhtbDpzcGFjZT0icHJlc2VydmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6c2VyaWY9Imh0dHA6Ly93d3cuc2VyaWYuY29tLyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPjxwYXRoIGQ9Ik0yNTUuMDIyLDUxMS45OThsMC4yMjksMC4wMDFsLTAuMDc5LDBsLTAuMTUsLTAuMDAxWm0xLjgwNiwwLjAwMWwtMC4wNzksMGwwLjIyOSwtMC4wMDFsLTAuMTUsMC4wMDFabS0yLjU4OCwtMC4wMDVsMC4yNDcsMC4wMDFsLTAuMTQyLDBsLTAuMTA1LC0wLjAwMVptMy40MTUsMC4wMDFsLTAuMTQyLDBsMC4yNDcsLTAuMDAxbC0wLjEwNSwwLjAwMVptLTQuMTY5LC0wLjAwN2wwLjE2NSwwLjAwMWwtMC4xMzIsLTAuMDAxbC0wLjAzMywwWm00Ljk5NSwwbC0wLjEzMiwwLjAwMWwwLjE2NSwtMC4wMDFsLTAuMDMzLDBabTAuODI2LC0wLjAwOWwtMC4wNTgsMC4wMDFsMC4yMjMsLTAuMDAzbC0wLjE2NSwwLjAwMlptLTYuNzc5LC0wLjAwMmwwLjIyMywwLjAwM2wtMC4wNTgsLTAuMDAxbC0wLjE2NSwtMC4wMDJabTcuNjA0LC0wLjAxbC0wLjEzNSwwLjAwMmwwLjI3NSwtMC4wMDRsLTAuMTQsMC4wMDJabS04LjQwNCwtMC4wMDJsMC4yNzUsMC4wMDRsLTAuMTM1LC0wLjAwMmwtMC4xNCwtMC4wMDJabTkuMjI4LC0wLjAxMmwtMC4xODIsMC4wMDNsMC4yNTQsLTAuMDA1bC0wLjA3MiwwLjAwMlptLTkuOTg0LC0wLjAwMmwwLjI1NCwwLjAwNWwtMC4xODIsLTAuMDAzbC0wLjA3MiwtMC4wMDJabS0wLjkzNywtMC4wMTlsMC4yMjUsMC4wMDVsLTAuMDQsLTAuMDAxbC0wLjE4NSwtMC4wMDRabTExLjc0NSwwLjAwNGwtMC4wNCwwLjAwMWwwLjIyNSwtMC4wMDVsLTAuMTg1LDAuMDA0Wm0tMTIuNTY3LC0wLjAyNWwwLjMwOSwwLjAwOGwtMC4xMjUsLTAuMDAzbC0wLjE4NCwtMC4wMDVabTEzLjM5LDAuMDA1bC0wLjEyNSwwLjAwM2wwLjMwOSwtMC4wMDhsLTAuMTg0LDAuMDA1Wm0wLjgyMywtMC4wMjJsLTAuMjAxLDAuMDA2bDAuMzE2LC0wLjAwOWwtMC4xMTUsMC4wMDNabS0xNC45NjcsLTAuMDAzbDAuMzE2LDAuMDA5bC0wLjIwMSwtMC4wMDZsLTAuMTE1LC0wLjAwM1ptLTAuNzIsLTAuMDIybDAuMjI1LDAuMDA3bC0wLjIxMiwtMC4wMDdsLTAuMTk0LC0wLjAwNmwwLjE4MSwwLjAwNlptMTYuNTA5LDBsLTAuMjEyLDAuMDA3bDAuMjI1LC0wLjAwN2wwLjE4MSwtMC4wMDZsLTAuMTk0LDAuMDA2Wm0wLjgyMSwtMC4wMjdsLTAuMTEyLDAuMDA0bDAuMzQ1LC0wLjAxMmwtMC4yMzMsMC4wMDhabS0xOC4zNzEsLTAuMDA4bDAuMzQ1LDAuMDEybC0wLjExMiwtMC4wMDRsLTAuMjMzLC0wLjAwOFptLTAuNzQ5LC0wLjAyOGwwLjM2MiwwLjAxM2wtMC4yMDEsLTAuMDA3bC0wLjE2MSwtMC4wMDZabTE5Ljk0MSwwLjAwNmwtMC4yMDEsMC4wMDdsMC4zNjIsLTAuMDEzbC0wLjE2MSwwLjAwNlptLTIwLjY3NiwtMC4wMzZsMC4zNTQsMC4wMTVsLTAuMjc3LC0wLjAxMWwtMC4wNzcsLTAuMDA0Wm0yMS40OTUsMC4wMDRsLTAuMjc3LDAuMDExbDAuMzU0LC0wLjAxNWwtMC4wNzcsMC4wMDRabS0yMi41MjUsLTAuMDQ5bDAuMzgsMC4wMTdsLTAuMDkzLC0wLjAwM2wtMC4yODcsLTAuMDE0Wm0yMy4zNDUsMC4wMTRsLTAuMDkzLDAuMDAzbDAuMzgsLTAuMDE3bC0wLjI4NywwLjAxNFptLTI0LjA4NCwtMC4wNDhsMC4zOTQsMC4wMThsLTAuMTg2LC0wLjAwOGwtMC4yMDgsLTAuMDFabTI0LjkwMiwwLjAxbC0wLjE4NiwwLjAwOGwwLjM5NCwtMC4wMThsLTAuMjA4LDAuMDFabS0yNS42MywtMC4wNDdsMC4zOTcsMC4wMmwtMC4yNzksLTAuMDEzbC0wLjExOCwtMC4wMDdabTI2LjQ0OCwwLjAwN2wtMC4yNzksMC4wMTNsMC4zOTcsLTAuMDJsLTAuMTE4LDAuMDA3Wm0wLjgxOCwtMC4wNDNsLTAuMzYyLDAuMDE5bDAuMzIxLC0wLjAxN2wwLjM3OCwtMC4wMjFsLTAuMzM3LDAuMDE5Wm0tMjcuOTI1LDAuMDAybDAuMzIxLDAuMDE3bC0wLjM2MiwtMC4wMTlsLTAuMzM3LC0wLjAxOWwwLjM3OCwwLjAyMVptMjguNzQxLC0wLjA0OGwtMC4xNiwwLjAwOWwwLjQwNiwtMC4wMjNsLTAuMjQ2LDAuMDE0Wm0tMjkuODQ0LC0wLjAxNGwwLjQwNiwwLjAyM2wtMC4xNiwtMC4wMDlsLTAuMjQ2LC0wLjAxNFptLTAuNzIyLC0wLjA0M2wwLjQwNSwwLjAyNGwtMC4yNTMsLTAuMDE0bC0wLjE1MiwtMC4wMVptMzEuMzgyLDAuMDFsLTAuMjUzLDAuMDE0bDAuNDA1LC0wLjAyNGwtMC4xNTIsMC4wMVptLTMyLjA3MSwtMC4wNTNsMC4zNjUsMC4wMjNsLTAuMzQsLTAuMDIxbC0wLjM0MiwtMC4wMjJsMC4zMTcsMC4wMlptMzIuODg3LDAuMDAybC0wLjM0LDAuMDIxbDAuMzY1LC0wLjAyM2wwLjMxNywtMC4wMmwtMC4zNDIsMC4wMjJabTAuODE0LC0wLjA1M2wtMC4xMjIsMC4wMDhsMC4zODcsLTAuMDI2bC0wLjI2NSwwLjAxOFptLTM0Ljc1NSwtMC4wMThsMC4zODcsMC4wMjZsLTAuMTIyLC0wLjAwOGwtMC4yNjUsLTAuMDE4Wm0tMC43MjEsLTAuMDVsMC4zOCwwLjAyN2wtMC4yMDgsLTAuMDE0bC0wLjE3MiwtMC4wMTNabTM2LjI5LDAuMDEzbC0wLjIwOCwwLjAxNGwwLjM4LC0wLjAyN2wtMC4xNzIsMC4wMTNabS0zNy4wMDksLTAuMDY0bDAuMzQ5LDAuMDI1bC0wLjI3MSwtMC4wMTlsLTAuMDc4LC0wLjAwNlptMzcuODIyLDAuMDA2bC0wLjI3MSwwLjAxOWwwLjM0OSwtMC4wMjVsLTAuMDc4LDAuMDA2Wm0tMzguNzg5LC0wLjA3OWwwLjMwNiwwLjAyM2wtMC4wNzQsLTAuMDA1bC0wLjIzMiwtMC4wMThabTM5LjYwMiwwLjAxOGwtMC4wNzQsMC4wMDVsMC4zMDYsLTAuMDIzbC0wLjIzMiwwLjAxOFptMC44MTEsLTAuMDYzbC0wLjE0NiwwLjAxMWwwLjMxMSwtMC4wMjVsLTAuMTY1LDAuMDE0Wm0tNDEuMTU3LC0wLjAxNGwwLjMxMSwwLjAyNWwtMC4xNDYsLTAuMDExbC0wLjE2NSwtMC4wMTRabS0wLjcyNSwtMC4wNTlsMC4yNjQsMC4wMjJsLTAuMTg2LC0wLjAxNWwtMC4wNzgsLTAuMDA3Wm00Mi42OTQsMC4wMDdsLTAuMTg2LDAuMDE1bDAuMjY0LC0wLjAyMmwtMC4wNzgsMC4wMDdabS00My40OTIsLTAuMDc0bDAuMDc5LDAuMDA3bC0wLjAxMywtMC4wMDFsLTAuMDY2LC0wLjAwNlptNDQuMzAyLDAuMDA2bC0wLjAxMywwLjAwMWwwLjA3OSwtMC4wMDdsLTAuMDY2LDAuMDA2Wm0wLjgxLC0wLjA3MWwtMC4wNzIsMC4wMDZsMC4xODEsLTAuMDE2bC0wLjEwOSwwLjAxWm0tNDUuOTY1LC0wLjAxbDAuMTgxLDAuMDE2bC0wLjA3MiwtMC4wMDZsLTAuMTA5LC0wLjAxWm0tMC43NSwtMC4wNjhsMC4xMzUsMC4wMTNsLTAuMDg0LC0wLjAwOGwtMC4wNTEsLTAuMDA1Wm00Ny41MjMsMC4wMDVsLTAuMDg0LDAuMDA4bDAuMTM1LC0wLjAxM2wtMC4wNTEsMC4wMDVabS02My43MzYsLTIuMDI1Yy0xMjIuMzE5LC0xOS4yMjYgLTIxNiwtMTI1LjIwMyAtMjE2LC0yNTIuODg3YzAsLTE0MS4yOSAxMTQuNzEsLTI1NiAyNTYsLTI1NmMxNDEuMjksMCAyNTYsMTE0LjcxIDI1NiwyNTZjMCwxMjcuNjg0IC05My42ODEsMjMzLjY2MSAtMjE2LDI1Mi44ODdsMCwtMTc4Ljg4N2w1OS42NSwwbDExLjM1LC03NGwtNzEsMGwwLC00OC4wMjFjMCwtMjAuMjQ1IDkuOTE4LC0zOS45NzkgNDEuNzE5LC0zOS45NzlsMzIuMjgxLDBsMCwtNjNjMCwwIC0yOS4yOTYsLTUgLTU3LjMwNSwtNWMtNTguNDc2LDAgLTk2LjY5NSwzNS40NCAtOTYuNjk1LDk5LjZsMCw1Ni40bC02NSwwbDAsNzRsNjUsMGwwLDE3OC44ODdaIi8+PC9zdmc+',
    'twitter_icon'                  => 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/PjwhRE9DVFlQRSBzdmcgIFBVQkxJQyAnLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4nICAnaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkJz48c3ZnIGhlaWdodD0iMTAwJSIgc3R5bGU9ImZpbGwtcnVsZTpldmVub2RkO2NsaXAtcnVsZTpldmVub2RkO3N0cm9rZS1saW5lam9pbjpyb3VuZDtzdHJva2UtbWl0ZXJsaW1pdDoyOyIgdmVyc2lvbj0iMS4xIiB2aWV3Qm94PSIwIDAgNTEyIDUxMiIgd2lkdGg9IjEwMCUiIHhtbDpzcGFjZT0icHJlc2VydmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6c2VyaWY9Imh0dHA6Ly93d3cuc2VyaWYuY29tLyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPjxwYXRoIGQ9Ik0yNTYsMGMxNDEuMjksMCAyNTYsMTE0LjcxIDI1NiwyNTZjMCwxNDEuMjkgLTExNC43MSwyNTYgLTI1NiwyNTZjLTE0MS4yOSwwIC0yNTYsLTExNC43MSAtMjU2LC0yNTZjMCwtMTQxLjI5IDExNC43MSwtMjU2IDI1NiwtMjU2Wm0tNDUuMDkxLDM5Mi4xNThjMTEzLjI4MywwIDE3NS4yMjQsLTkzLjg3IDE3NS4yMjQsLTE3NS4yMjNjMCwtMi42ODIgMCwtNS4zNjQgLTAuMTI4LC03LjkxOWMxMi4wMDUsLTguNjg0IDIyLjQ3OCwtMTkuNTQgMzAuNzc5LC0zMS45MjhjLTEwLjk4Myw0Ljg1MyAtMjIuODYxLDguMTc0IC0zNS4zNzcsOS43MDZjMTIuNzcyLC03LjY2MyAyMi40NzgsLTE5LjY2OCAyNy4wNzYsLTM0LjA5OWMtMTEuODc4LDcuMDI0IC0yNS4wMzIsMTIuMTMyIC0zOS4wODEsMTQuOTQyYy0xMS4yMzksLTEyLjAwNSAtMjcuMjAzLC0xOS40MTIgLTQ0Ljk1NSwtMTkuNDEyYy0zMy45NzIsMCAtNjEuNTU4LDI3LjU4NiAtNjEuNTU4LDYxLjU1OGMwLDQuODUzIDAuNTExLDkuNTc4IDEuNjYsMTQuMDQ4Yy01MS4yMTMsLTIuNTU0IC05Ni41NTIsLTI3LjA3NSAtMTI2Ljk0NywtNjQuMzY4Yy01LjIzNyw5LjA2OCAtOC4zMDIsMTkuNjY4IC04LjMwMiwzMC45MDdjMCwyMS4zMjggMTAuODU2LDQwLjIzIDI3LjQ1OSw1MS4yMTNjLTEwLjA5LC0wLjI1NSAtMTkuNTQxLC0zLjA2NSAtMjcuODQyLC03LjY2MmwwLDAuNzY2YzAsMjkuODg1IDIxLjIsNTQuNjYxIDQ5LjQyNSw2MC40MDljLTUuMTA4LDEuNDA0IC0xMC42LDIuMTcxIC0xNi4yMTksMi4xNzFjLTMuOTYsMCAtNy43OTEsLTAuMzgzIC0xMS42MjIsLTEuMTVjNy43OSwyNC41MjEgMzAuNTIzLDQyLjI3NCA1Ny40NzEsNDIuNzg0Yy0yMS4wNzMsMTYuNDc2IC00Ny42MzcsMjYuMzEgLTc2LjUwMSwyNi4zMWMtNC45ODEsMCAtOS44MzQsLTAuMjU2IC0xNC42ODcsLTAuODk0YzI2Ljk0OCwxNy42MjQgNTkuMzg3LDI3Ljg0MSA5NC4xMjUsMjcuODQxWiIvPjwvc3ZnPg==',
    'instagram_icon'                => 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/PjwhRE9DVFlQRSBzdmcgIFBVQkxJQyAnLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4nICAnaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkJz48c3ZnIGhlaWdodD0iMTAwJSIgc3R5bGU9ImZpbGwtcnVsZTpldmVub2RkO2NsaXAtcnVsZTpldmVub2RkO3N0cm9rZS1saW5lam9pbjpyb3VuZDtzdHJva2UtbWl0ZXJsaW1pdDoyOyIgdmVyc2lvbj0iMS4xIiB2aWV3Qm94PSIwIDAgNTEyIDUxMiIgd2lkdGg9IjEwMCUiIHhtbDpzcGFjZT0icHJlc2VydmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6c2VyaWY9Imh0dHA6Ly93d3cuc2VyaWYuY29tLyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPjxwYXRoIGQ9Ik0yNTYsMGMxNDEuMjksMCAyNTYsMTE0LjcxIDI1NiwyNTZjMCwxNDEuMjkgLTExNC43MSwyNTYgLTI1NiwyNTZjLTE0MS4yOSwwIC0yNTYsLTExNC43MSAtMjU2LC0yNTZjMCwtMTQxLjI5IDExNC43MSwtMjU2IDI1NiwtMjU2Wm0wLDk2Yy00My40NTMsMCAtNDguOTAyLDAuMTg0IC02NS45NjgsMC45NjNjLTE3LjAzLDAuNzc3IC0yOC42NjEsMy40ODIgLTM4LjgzOSw3LjQzN2MtMTAuNTIxLDQuMDg5IC0xOS40NDQsOS41NiAtMjguMzM5LDE4LjQ1NWMtOC44OTUsOC44OTUgLTE0LjM2NiwxNy44MTggLTE4LjQ1NSwyOC4zMzljLTMuOTU1LDEwLjE3NyAtNi42NTksMjEuODA4IC03LjQzNywzOC44MzhjLTAuNzc4LDE3LjA2NiAtMC45NjIsMjIuNTE1IC0wLjk2Miw2NS45NjhjMCw0My40NTMgMC4xODQsNDguOTAyIDAuOTYyLDY1Ljk2OGMwLjc3OCwxNy4wMyAzLjQ4MiwyOC42NjEgNy40MzcsMzguODM4YzQuMDg5LDEwLjUyMSA5LjU2LDE5LjQ0NCAxOC40NTUsMjguMzRjOC44OTUsOC44OTUgMTcuODE4LDE0LjM2NiAyOC4zMzksMTguNDU1YzEwLjE3OCwzLjk1NCAyMS44MDksNi42NTkgMzguODM5LDcuNDM2YzE3LjA2NiwwLjc3OSAyMi41MTUsMC45NjMgNjUuOTY4LDAuOTYzYzQzLjQ1MywwIDQ4LjkwMiwtMC4xODQgNjUuOTY4LC0wLjk2M2MxNy4wMywtMC43NzcgMjguNjYxLC0zLjQ4MiAzOC44MzgsLTcuNDM2YzEwLjUyMSwtNC4wODkgMTkuNDQ0LC05LjU2IDI4LjM0LC0xOC40NTVjOC44OTUsLTguODk2IDE0LjM2NiwtMTcuODE5IDE4LjQ1NSwtMjguMzRjMy45NTQsLTEwLjE3NyA2LjY1OSwtMjEuODA4IDcuNDM2LC0zOC44MzhjMC43NzksLTE3LjA2NiAwLjk2MywtMjIuNTE1IDAuOTYzLC02NS45NjhjMCwtNDMuNDUzIC0wLjE4NCwtNDguOTAyIC0wLjk2MywtNjUuOTY4Yy0wLjc3NywtMTcuMDMgLTMuNDgyLC0yOC42NjEgLTcuNDM2LC0zOC44MzhjLTQuMDg5LC0xMC41MjEgLTkuNTYsLTE5LjQ0NCAtMTguNDU1LC0yOC4zMzljLTguODk2LC04Ljg5NSAtMTcuODE5LC0xNC4zNjYgLTI4LjM0LC0xOC40NTVjLTEwLjE3NywtMy45NTUgLTIxLjgwOCwtNi42NiAtMzguODM4LC03LjQzN2MtMTcuMDY2LC0wLjc3OSAtMjIuNTE1LC0wLjk2MyAtNjUuOTY4LC0wLjk2M1ptMCwyOC44MjljNDIuNzIyLDAgNDcuNzgyLDAuMTYzIDY0LjY1NCwwLjkzM2MxNS42LDAuNzEyIDI0LjA3MSwzLjMxOCAyOS43MDksNS41MDljNy40NjksMi45MDIgMTIuNzk5LDYuMzcgMTguMzk3LDExLjk2OWM1LjYsNS41OTggOS4wNjcsMTAuOTI5IDExLjk2OSwxOC4zOTdjMi4xOTEsNS42MzggNC43OTgsMTQuMTA5IDUuNTA5LDI5LjcwOWMwLjc3LDE2Ljg3MiAwLjkzMywyMS45MzIgMC45MzMsNjQuNjU0YzAsNDIuNzIyIC0wLjE2Myw0Ny43ODIgLTAuOTMzLDY0LjY1NGMtMC43MTEsMTUuNiAtMy4zMTgsMjQuMDcxIC01LjUwOSwyOS43MDljLTIuOTAyLDcuNDY5IC02LjM2OSwxMi43OTkgLTExLjk2OSwxOC4zOTdjLTUuNTk4LDUuNiAtMTAuOTI4LDkuMDY3IC0xOC4zOTcsMTEuOTY5Yy01LjYzOCwyLjE5MSAtMTQuMTA5LDQuNzk4IC0yOS43MDksNS41MDljLTE2Ljg2OSwwLjc3IC0yMS45MjksMC45MzMgLTY0LjY1NCwwLjkzM2MtNDIuNzI1LDAgLTQ3Ljc4NCwtMC4xNjMgLTY0LjY1NCwtMC45MzNjLTE1LjYsLTAuNzExIC0yNC4wNzEsLTMuMzE4IC0yOS43MDksLTUuNTA5Yy03LjQ2OSwtMi45MDIgLTEyLjc5OSwtNi4zNjkgLTE4LjM5OCwtMTEuOTY5Yy01LjU5OSwtNS41OTggLTkuMDY2LC0xMC45MjggLTExLjk2OCwtMTguMzk3Yy0yLjE5MSwtNS42MzggLTQuNzk4LC0xNC4xMDkgLTUuNTEsLTI5LjcwOWMtMC43NywtMTYuODcyIC0wLjkzMiwtMjEuOTMyIC0wLjkzMiwtNjQuNjU0YzAsLTQyLjcyMiAwLjE2MiwtNDcuNzgyIDAuOTMyLC02NC42NTRjMC43MTIsLTE1LjYgMy4zMTksLTI0LjA3MSA1LjUxLC0yOS43MDljMi45MDIsLTcuNDY4IDYuMzY5LC0xMi43OTkgMTEuOTY4LC0xOC4zOTdjNS41OTksLTUuNTk5IDEwLjkyOSwtOS4wNjcgMTguMzk4LC0xMS45NjljNS42MzgsLTIuMTkxIDE0LjEwOSwtNC43OTcgMjkuNzA5LC01LjUwOWMxNi44NzIsLTAuNzcgMjEuOTMyLC0wLjkzMyA2NC42NTQsLTAuOTMzWm0wLDQ5LjAwOWMtNDUuMzc3LDAgLTgyLjE2MiwzNi43ODUgLTgyLjE2Miw4Mi4xNjJjMCw0NS4zNzcgMzYuNzg1LDgyLjE2MiA4Mi4xNjIsODIuMTYyYzQ1LjM3NywwIDgyLjE2MiwtMzYuNzg1IDgyLjE2MiwtODIuMTYyYzAsLTQ1LjM3NyAtMzYuNzg1LC04Mi4xNjIgLTgyLjE2MiwtODIuMTYyWm0wLDEzNS40OTVjLTI5LjQ1NSwwIC01My4zMzMsLTIzLjg3OCAtNTMuMzMzLC01My4zMzNjMCwtMjkuNDU1IDIzLjg3OCwtNTMuMzMzIDUzLjMzMywtNTMuMzMzYzI5LjQ1NSwwIDUzLjMzMywyMy44NzggNTMuMzMzLDUzLjMzM2MwLDI5LjQ1NSAtMjMuODc4LDUzLjMzMyAtNTMuMzMzLDUzLjMzM1ptMTA0LjYwOSwtMTM4Ljc0MWMwLDEwLjYwNCAtOC41OTcsMTkuMTk5IC0xOS4yMDEsMTkuMTk5Yy0xMC42MDMsMCAtMTkuMTk5LC04LjU5NSAtMTkuMTk5LC0xOS4xOTljMCwtMTAuNjA0IDguNTk2LC0xOS4yIDE5LjE5OSwtMTkuMmMxMC42MDQsMCAxOS4yMDEsOC41OTYgMTkuMjAxLDE5LjJaIi8+PC9zdmc+',
    'github_icon'                   => 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/PjxzdmcgaGVpZ2h0PSIxMDI0IiB3aWR0aD0iMTAyNCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cGF0aCBkPSJNNTEyIDBDMjI5LjI1IDAgMCAyMjkuMjUgMCA1MTJjMCAyMjYuMjUgMTQ2LjY4OCA0MTguMTI1IDM1MC4xNTYgNDg1LjgxMiAyNS41OTQgNC42ODggMzQuOTM4LTExLjEyNSAzNC45MzgtMjQuNjI1IDAtMTIuMTg4LTAuNDY5LTUyLjU2Mi0wLjcxOS05NS4zMTJDMjQyIDkwOC44MTIgMjExLjkwNiA4MTcuNSAyMTEuOTA2IDgxNy41Yy0yMy4zMTItNTkuMTI1LTU2Ljg0NC03NC44NzUtNTYuODQ0LTc0Ljg3NS00Ni41MzEtMzEuNzUgMy41My0zMS4xMjUgMy41My0zMS4xMjUgNTEuNDA2IDMuNTYyIDc4LjQ3IDUyLjc1IDc4LjQ3IDUyLjc1IDQ1LjY4OCA3OC4yNSAxMTkuODc1IDU1LjYyNSAxNDkgNDIuNSA0LjY1NC0zMyAxNy45MDQtNTUuNjI1IDMyLjUtNjguMzc1QzMwNC45MDYgNzI1LjQzOCAxODUuMzQ0IDY4MS41IDE4NS4zNDQgNDg1LjMxMmMwLTU1LjkzOCAxOS45NjktMTAxLjU2MiA1Mi42NTYtMTM3LjQwNi01LjIxOS0xMy0yMi44NDQtNjUuMDk0IDUuMDYyLTEzNS41NjIgMCAwIDQyLjkzOC0xMy43NSAxNDAuODEyIDUyLjUgNDAuODEyLTExLjQwNiA4NC41OTQtMTcuMDMxIDEyOC4xMjUtMTcuMjE5IDQzLjUgMC4xODggODcuMzEyIDUuODc1IDEyOC4xODggMTcuMjgxIDk3LjY4OC02Ni4zMTIgMTQwLjY4OC01Mi41IDE0MC42ODgtNTIuNSAyOCA3MC41MzEgMTAuMzc1IDEyMi41NjIgNS4xMjUgMTM1LjUgMzIuODEyIDM1Ljg0NCA1Mi42MjUgODEuNDY5IDUyLjYyNSAxMzcuNDA2IDAgMTk2LjY4OC0xMTkuNzUgMjQwLTIzMy44MTIgMjUyLjY4OCAxOC40MzggMTUuODc1IDM0Ljc1IDQ3IDM0Ljc1IDk0Ljc1IDAgNjguNDM4LTAuNjg4IDEyMy42MjUtMC42ODggMTQwLjUgMCAxMy42MjUgOS4zMTIgMjkuNTYyIDM1LjI1IDI0LjU2MkM4NzcuNDM4IDkzMCAxMDI0IDczOC4xMjUgMTAyNCA1MTIgMTAyNCAyMjkuMjUgNzk0Ljc1IDAgNTEyIDB6Ii8+PC9zdmc+',
    'favicon'                       => 'data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=',
];